﻿using UnityEngine;

public class VertexColours : MonoBehaviour
{
	// public properties
	public Color[] Colours = new Color[] { Color.white };

	public enum Modes { Static, Animated };
	public Modes Mode;

	private Color[] ColourPallete = new Color[] { Color.white, Color.white, Color.white, Color.white };
	private float[] Saturations = new float[] { 1.0f, 0.75f, 0.5f, 0.25f };

	void Awake()
	{
		var mesh = GetComponent<MeshFilter>().mesh;
		var vert = mesh.vertices;
		var cam = GetComponentInParent<Camera>();
		var vpbl = new Vector3(0,0,0);
		var bl = cam.ViewportToWorldPoint(vpbl);
        var vptr = new Vector3(1,1,0);
		var tr = cam.ViewportToWorldPoint(vptr);
		vert[0].Set(bl.x, bl.y, 0);
		vert[2].Set(bl.x, tr.y, 0);
		vert[1].Set(tr.x, bl.y, 0);
		vert[3].Set(tr.x, tr.y, 0);
		mesh.vertices = vert;
	}

	void Start()
	{
		var index = ColourIndex % Colours.Length;
		var c = Colours[index];
		for (int i = 0; i < ColourPallete.Length; i++)
		{
			float h, s, v;
			Color.RGBToHSV(c, out h, out s, out v);
			s = Saturations[i];
			ColourPallete[i] = Color.HSVToRGB(h, s, v);
		}

		UpdateInternal();
	}

	public int ColourIndex
	{
		set
		{
			mColorIndex = value;
			Start();
		}
		get
		{
			return mColorIndex;
		}
	}

	void Update()
	{
		switch (Mode)
		{
			case Modes.Animated:
				UpdateInternal();
				break;
		}
	}

	void UpdateInternal()
	{
		var mesh = GetComponent<MeshFilter>().mesh;

		Vector3[] vertices = mesh.vertices;
		Color[] colors = new Color[vertices.Length];

		// morph colours
		int offset = 0;
		for (int i = 0; i < colors.Length; i++)
		{
			switch (Mode)
			{
				case Modes.Animated:
					var from = ColourPallete[(offset + mColourIndex) % ColourPallete.Length];
					offset++;
					var to = ColourPallete[(offset + mColourIndex) % ColourPallete.Length];
					colors[i] = Color.Lerp(from, to, mT);
					break;

				case Modes.Static:
					var at = ColourPallete[i % ColourPallete.Length];
					colors[i] = at;
					break;
			}
		}

		//Debug.Log(colors.Length);

		// re-assign colours
		mesh.colors = colors;

		// animate
		mT += Time.deltaTime;
		if (mT > 1.0f)
		{
			mT -= 1.0f;
			mColourIndex++;
		}
	}

    // private 
	private float mT;
	private int mColourIndex;
	private int mColorIndex;
}
