﻿using UnityEngine;
using System.Collections.Generic;

public class HeightMap : MonoBehaviour
{
	public float Size = 1.0f;
	public float YMult = 5.0f;
	public int MapSize = 32;

	// Use this for initialization
	void Start()
	{
		Create();
	}
/*
	// Update is called once per frame
	float t = 0.0f;
	float[] v;
	void Update()
	{
		var mesh = GetComponent<MeshFilter>().mesh;

		float x = 0.0f;
		if (v == null)
		{
			v = new float[mesh.vertices.Length];
			for (int f = 0; f < v.Length; ++f)
			{
				v[f] = x;
				x += Random.Range(0, Mathf.PI/2);
			}
		}

		var newVertices = new Vector3[mesh.vertices.Length];

		for (int i = 0; i < newVertices.Length; i++)
		{
			newVertices[i] = mesh.vertices[i];
			newVertices[i].y = YMult * Mathf.Sin(v[i] + t);
		}

		mesh.vertices = newVertices;
		mesh.RecalculateNormals();

		t += Time.deltaTime;
	}
*/
	void Create()
	{
		List<Vector3> verts = new List<Vector3>();
		List<int> tris = new List<int>();

		//Bottom left section of the map, other sections are similar
		for (int i = 0; i < MapSize; i++)
		{
			for (int j = 0; j < MapSize; j++)
			{
				//Add each new vertex in the plane
				verts.Add(new Vector3(i * Size, 0, j * Size));
				//Skip if a new square on the plane hasn't been formed
				if (i == 0 || j == 0) continue;

				int m = MapSize;
				//Adds the index of the three vertices in order to make up each of the two tris
				tris.Add(m * i + j); //Top right
				tris.Add(m * i + j - 1); //Bottom right
				tris.Add(m * (i - 1) + j - 1); //Bottom left - First triangle
				tris.Add(m * (i - 1) + j - 1); //Bottom left 
				tris.Add(m * (i - 1) + j); //Top left
				tris.Add(m * i + j); //Top right - Second triangle
			}
		}

		Vector2[] uvs = new Vector2[verts.Count];
		for (var i = 0; i < uvs.Length; i++) //Give UV coords X,Z world coords
		{
			uvs[i] = new Vector2(verts[i].x, verts[i].z);
		}

		var procMesh = new Mesh();
		procMesh.vertices = verts.ToArray(); //Assign verts, uvs, and tris to the mesh
		procMesh.uv = uvs;
		procMesh.triangles = tris.ToArray();
		procMesh.RecalculateNormals(); //Determines which way the triangles are facing
		GetComponent<MeshFilter>().mesh = procMesh; //Assign Mesh object to MeshFilter	
	}
}