﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public class GuiMain : MonoBehaviour, IGuiUpdate
{
	public Text LevelText;

	public AudioSource SfxAudio;

	public Toggle SfxToggle;
    public Toggle MusicToggle;

	public float DefaultSfxVolume = 0.5f;
	public Slider SfxSlider;
	public float DefaultMusicVolume = 0.5f;
	public Slider MusicSlider;

    public void OnToggleSfx(bool aOn)
    {
        PlayerPrefs.SetInt("SfxOn", aOn ? 1 : 0);
		UpdateState();
	}

	public void OnSliderSfx(float volume)
	{
		PlayerPrefs.SetFloat("SfxVolume", volume);
		UpdateState();
	}

	public void OnToggleMusic(bool aOn)
	{
		PlayerPrefs.SetInt("MusicOn", aOn ? 1 : 0);
		UpdateState();
	}

	public void OnSliderMusic(float volume)
	{
		PlayerPrefs.SetFloat("MusicVolume", volume);
		UpdateState();
	}

    public void UpdateState()
    {
        LevelText.text = "LEVEL " + Level.CurrentLevel;

        SfxToggle.isOn = PlayerPrefs.GetInt("SfxOn", 1) != 0;
		SfxSlider.value = PlayerPrefs.GetFloat("SfxVolume", DefaultSfxVolume);
		MusicToggle.isOn = PlayerPrefs.GetInt("MusicOn", 1) != 0;
		MusicSlider.value = PlayerPrefs.GetFloat("MusicVolume", DefaultMusicVolume);

		if (SfxAudio != null)
		{
			SfxAudio.mute = !SfxToggle.isOn;
			SfxAudio.volume = SfxSlider.value;
		}

		SoundManager.MuteMusic(Boot.sMuteMusic || !MusicToggle.isOn);
		SoundManager.SetVolume(MusicSlider.value);
	}
}
