﻿using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class GuiLevelSelect : MonoBehaviour, IGuiUpdate
{
	public GameObject ButtonPrefab;
	public GameObject LevelPanel;
	public Button LeftButton;
	public Button RightButton;
	public Text RankText;

	private int KLevelsPerPage { get { return Level.LevelsPerDifficulty; } }
	private int KPageCount { get { return Level.MaxLevels / KLevelsPerPage; } }

	void Awake()
	{
		for (int b = 0; b < KLevelsPerPage; b++)
		{
			var btn = Instantiate(ButtonPrefab);
			btn.transform.SetParent(LevelPanel.transform, false);
			int id = b;
			btn.GetComponent<Button>().onClick.AddListener(() => OnClickLevelButton(id));
		}

		mButtons = LevelPanel.GetComponentsInChildren<Button>();
	}

	public void UpdateState()
	{
		CurPage = ((Level.CurrentLevel-1) / KLevelsPerPage);
		ChangePage();
	}

	public void OnClickLeft()
	{
		CurPage--;
		if (CurPage < 0)
			CurPage = 0;
		ChangePage();
	}

	public void OnClickRight()
	{
		CurPage++;
		if (CurPage >= KPageCount)
			CurPage = KPageCount;
		ChangePage();
	}

	public void OnClickLevelButton(int aNum)
	{
		Level.CurrentLevel = CurPage*KLevelsPerPage + aNum + 1;
		FindObjectOfType<SceneLogic>().StartLevel(SceneLogic.StateChangeReason.LevelSelect);
	}

	private void ChangePage()
	{
		int start = CurPage * KLevelsPerPage + 1;
		for (int i=0 ; i<KLevelsPerPage ; i++)
		{
			int level = start + i;
			mButtons[i].interactable = (level <= Level.UnlockedLevel) || SceneLogic.DebugMode;
			mButtons[i].GetComponentInChildren<Text>().text = level.ToString("D2");

			var levelButton = mButtons[i].GetComponent<LevelButton>();
			levelButton.ShowTarget = level == Level.UnlockedLevel;
		}

		LeftButton.interactable = CurPage > 0;
		RightButton.interactable = CurPage < (KPageCount - 1);

		var levelObj = FindObjectOfType<Level>();
		RankText.text = levelObj.GetRankString(CurPage);
	}

	// private variables
	private int CurPage { get; set; }
	private Button[] mButtons;
}
