﻿using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class GuiBallSelect : MonoBehaviour
{
	public Button LeftButton;
	public Button RightButton;
	public BallList BallList;
	public SceneLogic SceneLogic;
	public Text Name;

	void Awake()
	{
		Name.text = BallList.SelectedName;
	}

	public void OnClickLeft()
	{
		BallList.NextBall(-1);
		SceneLogic.InstantiateBall();
		Name.text = BallList.SelectedName;
	}

	public void OnClickRight()
	{
		BallList.NextBall(+1);
		SceneLogic.InstantiateBall();
		Name.text = BallList.SelectedName;
	}
}
