﻿using UnityEngine;
using System.Collections;

public class AnimItem : AnimBase
{
    // public properties
    public Vector2 SleepPosition;
    public float InSpeed = 1.0f;
    public float OutSpeed = 1.0f;

    void Start ()
    {
        var rt = GetComponent<RectTransform>();
        mAwakePosition = rt.localPosition;
    }
	
	// Update is called once per frame
	void Update ()
    {
        mT += Time.deltaTime * (Awake ? +1.0f : -1.0f) * (Awake ? InSpeed : OutSpeed);
        mT = Mathf.Clamp(mT, 0.0f, 1.0f);

        var at = Vector2.Lerp(SleepPosition, mAwakePosition, mT);
        
        var rt = GetComponent<RectTransform>();
        rt.localPosition = at;
	}

    // private variables
    private Vector2 mAwakePosition;
    private float mT;
}
