﻿using UnityEngine;
using System.Collections;

public class SfxLogic : MonoBehaviour
{
    public enum Sfx { Thud, Bounce, Fail, Direction, LevelComplete, Gui };
    public AudioClip[] SfxList;

    public void PlaySfx(Sfx sfx)
    {
		var audioSource = GetComponent<AudioSource>();
        if (!gameObject.activeSelf || audioSource.mute)
            return;

#if UNITY_ANDROID && !UNITY_EDITOR
		int fx = (int)sfx;
		AudioCenter.playSound(AndroidSfx[fx], audioSource.volume);
#else
		// init audio
		audioSource.clip = SfxList[(int)sfx];
        audioSource.Play();
#endif
    }

    void Start()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
		AndroidSfx = new int[SfxList.Length];
		for (int fx = 0; fx < AndroidSfx.Length; ++fx)
		{
			var file = SfxList[fx].name;
			AndroidSfx[fx] = AudioCenter.loadSound(file);
		}
#endif
    }

    void OnDestroy()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
		for (int fx = 0; fx < AndroidSfx.Length; ++fx)
		{
			var id = AndroidSfx[fx];
			AudioCenter.unloadSound(id);
		}
#else
        // reset audio
        var audioSource = GetComponent<AudioSource>();
        audioSource.Stop();
#endif
    }

    // private variables
#if UNITY_ANDROID && !UNITY_EDITOR
	private int[] AndroidSfx = null;
#endif
}
