﻿using UnityEngine;
using System.Collections;

public class Boot : MonoBehaviour
{
	public static bool sHideGui = false;
	public static bool sMuteMusic = false;

	public int Width = 768;
	public int Height = 1024;
	public bool Fullscreen = false;
	public string MainScene = "Main";

	public bool HideGui = false;
	public bool MuteMusic = false;

	void Start()
	{
		// window specific overrides
		if (Application.platform == RuntimePlatform.WindowsPlayer)
		{
			// override resolution
			Screen.SetResolution(Width, Height, Fullscreen);

			// override to highest quality
			QualitySettings.SetQualityLevel(QualitySettings.names.Length - 1, true);

			// vsync on
			QualitySettings.vSyncCount = 1;
		}

		// instance -> static
		sHideGui = HideGui;
		sMuteMusic = MuteMusic;

		// boot main scene
		StartCoroutine("Go");
	}

	public IEnumerator Go()
	{
		var async = UnityEngine.SceneManagement.SceneManager.LoadSceneAsync(MainScene, UnityEngine.SceneManagement.LoadSceneMode.Single);
		yield return async;
	}
}
