﻿using UnityEngine;
using System.Collections;

public class BallList : MonoBehaviour
{
	public GameObject[] Balls;

	public string CurrentBall
	{
		get { return PlayerPrefs.GetString("CurrentBall", string.Empty); }
		set { PlayerPrefs.SetString("CurrentBall", value); }
	}

	public string SelectedName
	{
		get
		{
			var rv = string.Empty;

			if (SelectedBall != null)
			{
				var ball = SelectedBall.GetComponent<Ball>();
				rv = ball.Name;
			}

			return rv;
		}
	}

	public GameObject SelectedBall
	{
		get
		{
			var name = CurrentBall;
			var defaultName = Balls.Length > 0 ? Balls[0].name : string.Empty;
			if (string.IsNullOrEmpty(name) && !string.IsNullOrEmpty(defaultName))
			{
				// use default
				name = defaultName;
			}

			for (int b = 0; b < Balls.Length; ++b)
			{
				if (Balls[b].name == name)
				{
					CurrentBall = name;

					// found
					return Balls[b];
				}
			}

			// fallback
			return Balls.Length > 0 ? Balls[0] : null;
		}
	}

	public void NextBall(int offset)
	{
		// get current
		var current = SelectedBall;

		int foundIndex = -1;
		for (int b = 0; b < Balls.Length; ++b)
		{
			if (Balls[b].name == current.name)
			{
				// found at
				foundIndex = b;
			}
		}

		int index = (foundIndex + offset);
		if (index < 0)
		{
			// wrap left
			index = Balls.Length - 1;
		}
		else if (index >= Balls.Length)
		{
			// wrap right
			index = 0;
		}

		var name = Balls[index].name;

		// re-assign as new current
		CurrentBall = name;
	}
}
