﻿using UnityEngine;

public class Ball : MonoBehaviour
{
	// public properties
	public Vector3 Direction;
    public Vector3 Velocity;
    public bool OnGround;

	public Texture Texture;
	public string Name = "Ninja";

	public GameObject Gfx;
	public GameObject Root;

	public float AirDrag = 0.1f;
    public float RotationZOffset = -90.0f;
	public float RotationSpeed = 16.0f;

    public float VisualZOffset
	{ 
		get { return 1.5f * 0.5f; }	// XXX: hard-coded hack
	}

	void Start()
	{
		if (Texture != null)
		{
			var mr = Gfx.GetComponentInChildren<MeshRenderer>();
			if (mr != null)
			{
				mr.material.SetTexture("_MainTex", Texture);
			}
		}

		UpdateInternal(true);
	}

	void Update()
	{
		UpdateInternal();
	}

	void UpdateInternal(bool instant = false)
	{
        // orientate gfx
        float r = Mathf.Atan2(Direction.y, Direction.x) * Mathf.Rad2Deg;

		var rot = Quaternion.Euler(0, 0, RotationZOffset + r);
		if (instant)
		{
			// instant
			transform.rotation = rot;
		}
		else
		{
			// smooth
			transform.rotation = Quaternion.Lerp(transform.rotation, rot, Time.deltaTime * RotationSpeed);
		}

		// detect if structure has extra node (if so we spin it, if not we spin gfx)
		var rollNode = Root != null ? Root : Gfx;
		var rollAxis = Root != null ? Vector3.right : Vector3.forward;
		float m = OnGround ? Velocity.magnitude : mResidual;
		rollNode.transform.Rotate(rollAxis, Mathf.Rad2Deg * m, Space.Self);

		mResidual = OnGround ? Velocity.magnitude : Mathf.Max(0, mResidual - (AirDrag * Time.deltaTime));
	}

	// private variables
	private float mResidual;
}
