﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public class Audio : MonoBehaviour
{
	public AudioSource SfxAudio;

	public float DefaultSfxVolume = 0.5f;
	public float DefaultMusicVolume = 0.5f;

	public void Awake()
	{
		ApplyAudio();
	}

	public void ApplyAudio()
	{
		var sfxOn = PlayerPrefs.GetInt("SfxOn", 1) != 0;
		var sfxVolume = PlayerPrefs.GetFloat("SfxVolume", DefaultSfxVolume);
		var musicOn = PlayerPrefs.GetInt("MusicOn", 1) != 0;
		var musicVolume = PlayerPrefs.GetFloat("MusicVolume", DefaultMusicVolume);
		
		if (SfxAudio != null)
		{
			SfxAudio.mute = !sfxOn;
			SfxAudio.volume = sfxVolume;
		}

		SoundManager.MuteMusic(Boot.sMuteMusic || !musicOn);
		SoundManager.SetVolume(musicVolume);
	}
}
